// Revisions:
// 	Version: v2.0.4 
//	Date:	 2/7/97 
//	Changed:
//		struct iPoint2D - now X&Y are 4 byte integers since 2.0.2
//
//		struct EAttr    - added data items since 2.0.0
//				 	float fWidth;
//					BYTE bByLayerFlag;
//
//		AlertApp - new AllertApp flags to notify redraw begin/end and print begin/end
//
////////////////////////////////////////////////////////////////////////////////////
//	Revisions:
//		Version: v3.0.0
//		Date: 11/26/98
//		Changed:
//			AlertApp: Added new AlertApp And AlertAppEx flags
//			
//			 


#define UNKNOWN				  0
#define LINE2D				  1
#define ARC2D				  2
#define CIRCLE2D			  3
#define ELLIPSE2D			  4
#define BEZIER2D			  5
#define POINT2D				  6
#define SYMBOL2D			  7
#define TEXT2D				  8
#define DIMLINEAR2D			  9
#define DIMANGULAR2D		 10
#define DIMRADIAL2D			 11
#define DIMDIAMETER2D		 12
#define FILL2D				 13
#define HATCH2D				 14
#define ATTRIBUTE2D			 15
#define INTERPCURV2D		 16
#define MINTERPCURV2D		 17
#define ELLIPTICALARC2D		 18
#define CONTINUOUSLINE2D	 19
#define CONTINUOUSBEZIER2D	 20
#define LEADER2D			 21
#define REFFRAME2D			 22
#define ORDDIM2D			 23
#define POLYGON3D			101
#define POINT3D				102
#define LINE3D				103
#define SYMBOL3D			104
#define CONTINUOUSLINE3D	105

typedef long ENTITYHANDLE;
typedef long WORLDHANDLE;
typedef long GRAPHICHANDLE;
typedef unsigned long UID;
typedef short vbool;

typedef struct iPoint2D {
	int x;	// 4-byte integers - long
	int y;
} iPoint2D;

typedef struct fPoint2D {
	float x;
	float y;
} fPoint2D;

typedef struct lPoint2D {
	long x;
	long y;
} lPoint2D;

typedef struct Point2D {
	double x;
	double y;
} Point2D;

typedef struct Point3D {
	double x;
	double y;
	double z;
} Point3D;

typedef struct EAttr {
	short iColor;
	short iLayer;
	short iLinetype;
	short iLinewidth;
	float fWidth;
	BYTE bByLayerFlag;
} EAttr;

//======================================================================================
// Defines for VCSetAlertApp, VCSetAlertAppEx,
//				VCSetAlertAppDll & VCSetAlertAppDllEx iCode0 Parameter
//======================================================================================
// the following are bit-wise "OR"ed together for the iCode0

#define ALERT_APP_ALL 						0

#define ALERT_APP_UTOOL_MOUSEDOWN 0x00000001
#define ALERT_APP_UTOOL_MOUSEDOWN_DLL "MouseDown"

#define ALERT_APP_UTOOL_MOUSEMOVE 0x00000002
#define ALERT_APP_UTOOL_MOUSEMOVE_DLL "MouseMove"

#define ALERT_APP_UTOOL_ABORT 0x00000004
#define ALERT_APP_UTOOL_ABORT_DLL "Abort"

#define ALERT_APP_CMDLINE_CHAR 0x00000008
#define ALERT_APP_CMDLINE_CHAR_DLL "Char"

#define ALERT_APP_CLOSE 0x00000010
#define ALERT_APP_CLOSE_DLL "AppClose"

#define ALERT_APP_UTOOL_PENUP 0x00000020
#define ALERT_APP_UTOOL_PENUP_DLL "PenUp"
#define ALERT_PENUP_CHARCODE 252
														 
#define ALERT_APP_WORLD_CLOSE 0x00000040 
#define ALERT_APP_WORLD_CLOSE_DLL	"DrawingClose"
#define ALERT_APP_WORLD_CLOSE_CHARCODE 253

#define ALERT_APP_UTOOL_ERASERUBBER 0x00000080
#define ALERT_APP_UTOOL_ERASERUBBER_DLL "EraseRubber"
#define ALERT_UTOOL_ERASERUBBER_CHARCODE 255

#define ALERT_APP_TOOL_COMPLETE 0x00000100
#define ALERT_APP_TOOL_COMPLETE_DLL "ToolComplete"
#define ALERT_TOOL_COMPLETE_CHARCODE 254

#define ALERT_APP_UTOOL_INIT 0x00000200
#define ALERT_APP_UTOOL_INIT_DLL "Init"
#define ALERT_UTOOL_INIT_CHARCODE 251

#define ALERT_APP_UTOOL_TERMINATE 0x00000400
#define ALERT_APP_UTOOL_TERMINATE_DLL "Terminate"
#define ALERT_UTOOL_TERMINATE_CHARCODE 250

#define ALERT_APP_FRAME_CLOSE 0x00000800
#define ALERT_APP_FRAME_CLOSE_DLL "FrameClose"
#define ALERT_FRAME_CLOSE_CHARCODE 249

#define ALERT_APP_FRAME_RESIZE 0x00001000
#define ALERT_APP_FRAME_RESIZE_DLL "FrameResize"
#define ALERT_FRAME_RESIZE_CHARCODE 248

#define ALERT_APP_ENTITY_ERASED 0x00002000
#define ALERT_APP_ENTITY_ERASED_DLL "EntityErased"
#define ALERT_APP_ENTITY_ERASED_CHARCODE 247

#define ALERT_APP_ENTITY_SELECT_CHANGE 0x00004000
#define ALERT_APP_ENTITY_SELECT_CHANGE_DLL "EntitySelectChange"
#define ALERT_APP_ENTITY_SELECT_CHANGE_CHARCODE 246

#define ALERT_APP_ACTIVATE 0x00008000
#define ALERT_APP_ACTIVATE_DLL "Activate"
#define ALERT_APP_ACTIVATE_CHARCODE 245

#define ALERT_APP_DEACTIVATE 0x00010000
#define ALERT_APP_DEACTIVATE_DLL "DeActivate"
#define ALERT_APP_DEACTIVATE_CHARCODE 244

#define ALERT_APP_UTOOL_MOUSEUP 0x00020000
#define ALERT_APP_UTOOL_MOUSEUP_DLL "MouseUp"

#define ALERT_APP_WORLD_MOUSEMOVE 0x00040000 
#define ALERT_APP_WORLD_MOUSEMOVE_DLL "WorldMouseMove"
#define ALERT_APP_WORLD_MOUSEMOVE_CHARCODE 243

#define ALERT_APP_WORLD_MOUSEDOWN 0x00080000 
#define ALERT_APP_WORLD_MOUSEDOWN_DLL "WorldMouseDown"
#define ALERT_APP_WORLD_MOUSEDOWN_CHARCODE 242

#define ALERT_APP_WORLD_MOUSEUP 0x00100000 
#define ALERT_APP_WORLD_MOUSEUP_DLL "WorldMouseUp"
#define ALERT_APP_WORLD_MOUSEUP_CHARCODE 241

#define ALERT_APP_WORLD_END_REDRAW 0x00200000 
#define ALERT_APP_WORLD_END_REDRAW_DLL "WorldEndRedraw"
#define ALERT_APP_WORLD_END_REDRAW_CHARCODE 240

#define ALERT_APP_WORLD_BEGIN_REDRAW 0x00400000 
#define ALERT_APP_WORLD_BEGIN_REDRAW_DLL "WorldBeginRedraw"
#define ALERT_APP_WORLD_BEGIN_REDRAW_CHARCODE 239

#define ALERT_APP_WORLD_BEGIN_PRINT 0x00800000
#define ALERT_APP_WORLD_BEGIN_PRINT_DLL "WorldBeginPrint"
#define ALERT_APP_WORLD_BEGIN_PRINT_CHARCODE 238

#define ALERT_APP_WORLD_END_PRINT 0x01000000 
#define ALERT_APP_WORLD_END_PRINT_DLL "WorldEndPrint"
#define ALERT_APP_WORLD_END_PRINT_CHARCODE 237

#define ALERT_APP_TOOL_START 0x02000000  
#define ALERT_APP_TOOL_START_DLL "ToolStart"
#define ALERT_APP_TOOL_START_CHARCODE 236

#define ALERT_APP_TOOL_ABORT 0x04000000  
#define ALERT_APP_TOOL_ABORT_DLL "ToolAbort"
#define ALERT_APP_TOOL_ABORT_CHARCODE 235

//======================================================================================
// Defines for VCSetAlertAppEx & VCSetAlertAppDllEx iCode1 Parameter
//======================================================================================
// the following are bit-wise "OR"ed together for the iCode1

#define ALERT_APP_EX_ALL 0xFFFFFFFF

#define ALERT_APP_EX_PRE_TRANSLATE_GET_MESSAGE 0x00000001
#define ALERT_APP_EX_PRE_TRANSLATE_GET_MESSAGE_DLL "PreTranslateGetMessage"
#define ALERT_APP_EX_PRE_TRANSLATE_GET_MESSAGE_CHARCODE 233

#define ALERT_APP_EX_PRE_TRANSLATE_FRAME_MESSAGE 0x00000002
#define ALERT_APP_EX_PRE_TRANSLATE_FRAME_MESSAGE_DLL "PreTranslateFrameMessage"
#define ALERT_APP_EX_PRE_TRANSLATE_FRAME_MESSAGE_CHARCODE 232

#define ALERT_APP_EX_PRE_TRANSLATE_DIALOG_MESSAGE 0x00000004
#define ALERT_APP_EX_PRE_TRANSLATE_DIALOG_MESSAGE_DLL "PreTranslateDialogMessage"
#define ALERT_APP_EX_PRE_TRANSLATE_DIALOG_MESSAGE_CHARCODE 231

// VCM_USER_ALERT Posted as the wParam of a WM_COMMAND Message will cause Visual Cadd
// to call the ALERT_APP_EX_USER_ALERT_MESSAGE The lParam the user sends in the WM_COMMAND
// message will be sent back to them. This call can be used to avoid recursion which can
// happen in many of the AlertApp messages such as starting a new tool from within the 
// AlertAppToolComplete message.
#define ALERT_APP_EX_USER_ALERT_MESSAGE 0x00000008 
#define ALERT_APP_EX_USER_ALERT_DLL "UserAlert"
#define ALERT_APP_EX_USER_ALERT_CHARCODE 230
#define VCM_USER_ALERT	2801

#define ALERT_APP_EX_DIALOG_OPEN_MESSAGE 0x00000010 
#define ALERT_APP_EX_DIALOG_OPEN_DLL "DialogOpen"
#define ALERT_APP_EX_DIALOG_OPEN_CHARCODE 229

#define ALERT_APP_EX_DIALOG_CLOSE_MESSAGE 0x00000020 
#define ALERT_APP_EX_DIALOG_CLOSE_DLL "DialogClose"
#define ALERT_APP_EX_DIALOG_CLOSE_CHARCODE 228

// API calls which use "SymbolIndex", use this parameter for entity section additions
#define NONDEFENTITY	-1
#define HATCHFILLENTITY	-2

// extern "C" void FAR PASCAL _export VCSetProjection3D(short* iError, short iCode);
#define VIEW3D_FLAT			0
#define VIEW3D_PARALLEL		1
#define VIEW3D_PERSPECTIVE	2

// extern "C" void FAR PASCAL _export VCSetView3DDisplay(short* iError, short iCode);
#define VIEW3D_WIREFRAME	0
#define VIEW3D_QSHADE		1

// extern "C" void FAR PASCAL _export VCSetView3DQShadeOptions(short* iError, short iCode);
#define QSHADE_ROUGH			0
#define QSHADE_EXACT			1
#define QSHADE_EXACT_AND_SPLIT	2

// extern "C" void FAR PASCAL _export VCChangeView3D(short* iError, short iCode, double dFact);
#define CHANGE_VIEW3D_LEFT	0
#define CHANGE_VIEW3D_RIGHT	1
#define CHANGE_VIEW3D_UP	2
#define CHANGE_VIEW3D_DOWN	3
												
// VC Supported File Types
#define FILE_VCD	 0
#define FILE_VCS	 1
#define FILE_VCA	 2
#define FILE_GCD	 3
#define FILE_CMP	 4
#define FILE_DWG	 5
#define FILE_DXF	 6
#define FILE_STY	 7
#define FILE_VCF	 8
#define FILE_EMF	 9
#define FILE_WMF	10

// Conversion unit constants
#define UNIT_INCH	 0
#define UNIT_FEET	 1
#define UNIT_MM		 2
#define UNIT_CM		 3
#define UNIT_M		 4
// V3
#define UNIT_MILE	10
#define UNIT_K		11

// Display unit
// V3
enum DisplayType {	InDec = 0, FtInDec = 1, FtDec = 2, 
					InFrac = 3, FtInFrac = 4, FtFrac = 5, 
					Mil = 6, Cen = 7, Met = 8, 
					AngDeg = 9, AngDMS = 10, 
					Mile = 20, Kilo = 21};

// Dimension mode
#define DIMMODESINGLE		0
#define DIMMODECUMULATIVE	1
#define DIMMODEPARTITIONED	2

// Dimension Direction
#define DIMALIGNED		1
#define DIMHORIZONTAL	2
#define DIMVERTICAL		3
#define DIMATANANGLE	4

// Tolerance Type
#define DIMNOTOLERANCE		0
#define DIMSTACKEDMINMAX	1
#define DIMSTACKEDVARIANCE	2
#define DIMFIXEDVARIANCE	3

// Extension
#define DIMEXTNOSTRETCH	0
#define DIMEXTSTRETCH	1

// Dimension Unit Type (Linear, Radial, or Diameter Dimensions)
#define DIMINCHES		1
#define DIMFEET			2
#define DIMMETERS		3
#define DIMMILLIMETERS	4
#define DIMCENTIMETERS	5
#define DIMFTIN			6

// Unit Type (Angular Dimensions)
#define DIMANGLEFORMATDECIMAL	0
#define DIMANGLEFORMATMINUTES	1

// Arrow Types
#define DIMARROWREGNOFILL		0
#define DIMARROWREGFILLED		1
#define DIMARROWREGOPEN			2
#define DIMARROWNOTCHED			3
#define DIMARROWSLASH			4
#define DIMARROWCIRCLENOFILL	5
#define DIMARROWCIRCLEFILL		6

// Dim Text
#define DIMTEXTINLINE		0
#define DIMTEXTABOVELINE	1
#define DIMTEXTFREEFLOAT	2

// Dim Text Rotation
#define DIMTEXTROTATIONALIGNED		0
#define DIMTEXTROTATIONHORIZONTAL	1

// Dim Line
#define DIMLINELEFT		0
#define DIMLINERIGHT	1

// Dimension Proximity Mode
#define DIMLINENOPROXFIX	0
#define DIMLINEPROXFIX		1

// Arrow Mode
#define DIMARROWNOFLIP	0
#define DIMARROWFLIP	1

// Dimension items
#define DIMLINE			0
#define DIMLEFTARROW	1
#define DIMRIGHTARROW	2
#define DIMLEFTEXT		3
#define DIMRIGHTEXT		4
#define DIMTEXT			5

// Datum modes
#define DATUMNONE	0
#define DATUMXY		1
#define DATUMX		2
#define DATUMY		3

// Justify modes
#define JUSTIFY_CENTER	67
#define JUSTIFY_LEFT	76
#define JUSTIFY_RIGHT	82

// Symbol explode layers
#define INDIVIDUAL_LAYER	0
#define PLACEMENT_LAYER		1
#define CURRENT_LAYER		2

// Autocad Import Unit Types
#define ACAD_UNIT_INCH	0
#define ACAD_UNIT_FEET	1
#define ACAD_UNIT_MILL	2
#define ACAD_UNIT_CENT	3
#define ACAD_UNIT_METER	4

// Printer/Plotter API definitions
#define PRINTMODE	0
#define PLOTMODE	1

#define FITTOPAPER	0
#define CURRENTVIEW	1
#define SCALE		2

#define PORTRAITMODE	0
#define LANDSCAPEMODE	1

#define METRICUNITS		0
#define ENGLISHUNITS	1

#define PORTCOM1	0
#define PORTCOM2	1
#define PORTCOM3	2
#define PORTCOM4	3
#define PORTLPT1	4
#define PORTLPT2	5
#define PORTLPT3	6
#define PORTFILE	7 

#define BAUD110		0
#define BAUD300		1
#define BAUD1200	2
#define BAUD2400	3
#define BAUD4800	4
#define BAUD9600	5
#define BAUD19200	6
#define BAUD38400	7
#define BAUD57600	8
                    		
#define DATABITS7	0
#define DATABITS8	1

#define PARITYODD	0
#define PARITYEVEN	1
#define PARITYNONE	2

#define STOPBITS1	0
#define STOPBITS2	1

typedef struct PrintStructTag {
	vbool 		tfPrintMode;
	Point2D 	PageSize;
	RECT		Margins;
	double		Scale;
	Point2D		Origin;
	short		ScaleMode;
	short		Orientation;
	double		Rotation;
	vbool		PrintToFile;
	vbool		SelectionOnly;
	vbool		DateStamp;
	vbool		FastPreview;
	vbool		AllColorsToBlack;
	short		PaperUnit;
} PrintStruct;

typedef struct PlotStructTag {
	short		Port;
	short 		BaudRate;
	short 		DataBits;
	short		Parity;
	short		StopBits;
	short		NumPens;
	short		NumCarousels;
	short 		DPI;
	vbool		UseCarousels;
	vbool		UseLLOrigin;
	vbool		SortColors;
	vbool		Optimize;
	vbool		BufferOutput;
} PlotStruct;

//	VCGetToolbar constants
#define TBNONE		0	//	no toolbar
#define TBTOP		1	//	the main speedbar
#define TBLEFT		2	//	the tool palette
#define TBRIGHT		3	//	not used
#define TBBOTTOM	4	//	the status bar
